/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Color;
import java.awt.Font;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.nooj4nlp.controller.preferencesdialog.AddGrmActionListener;
import net.nooj4nlp.controller.preferencesdialog.ApplyActionListener;
import net.nooj4nlp.controller.preferencesdialog.CancelActionListener;
import net.nooj4nlp.controller.preferencesdialog.CheckAllActionListener;
import net.nooj4nlp.controller.preferencesdialog.CopyToPreferences;
import net.nooj4nlp.controller.preferencesdialog.DefaultActionListener;
import net.nooj4nlp.controller.preferencesdialog.DeleteLexActionListener;
import net.nooj4nlp.controller.preferencesdialog.DictionariesActionListener;
import net.nooj4nlp.controller.preferencesdialog.EditLexActionListener;
import net.nooj4nlp.controller.preferencesdialog.ImportLexActionListener;
import net.nooj4nlp.controller.preferencesdialog.LoadActionListener;
import net.nooj4nlp.controller.preferencesdialog.PriorityLexActionListener;
import net.nooj4nlp.controller.preferencesdialog.PrioritySynActionListener;
import net.nooj4nlp.controller.preferencesdialog.RefreshActionListener;
import net.nooj4nlp.controller.preferencesdialog.SaveActionListener;
import net.nooj4nlp.controller.preferencesdialog.SaveAsDefaultActionListener;
import net.nooj4nlp.controller.preferencesdialog.SelectDefLanguageActionListener;
import net.nooj4nlp.controller.preferencesdialog.TextsActionListener;
import net.nooj4nlp.controller.preferencesdialog.UpdateDialogListener;
import net.nooj4nlp.controller.preferencesdialog.UpdateTablesListener;
import net.nooj4nlp.gui.dialogs.PreferenceResourcesTableSorter;
import net.nooj4nlp.gui.dialogs.PreferenceTableSorter;
import net.nooj4nlp.gui.main.Launcher;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = -1594043405334641461L;
    private String oldLan;
    private JComboBox cbDefLanguage;
    private Font DFont = null;
    private Font TFont = null;
    private JTable tableMorphology;
    private JTable tableDictionary;
    private JTable tableResources;
    private JList listSynResources;
    private JButton btnImportFileLex;
    private JButton btnImportFileSyn;
    private JButton btnDeleteFileLex;
    private JButton btnDeleteFileSyn;
    private JButton btnHigh;
    private JButton btnLow;
    private JButton btnEditLex;
    private JLabel lblLexDoc;
    private JLabel lblSynDoc;
    private JTextArea txtFileInfoLex;
    private JTextArea txtFileInfoSyn;
    private UpdateDialogListener updateDialogListener;
    private SelectDefLanguageActionListener selectDefLanguageListener;

    public PreferencesDialog() {
        boolean enable;
        this.oldLan = Launcher.preferences.deflanguage;
        boolean bl = enable = !Launcher.projectMode;
        if (enable) {
            this.setTitle("Preferences");
        } else {
            this.setTitle("Preferences are frozen in project mode");
        }
        this.setBounds(100, 100, 550, 581);
        this.getContentPane().setLayout(null);
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBounds(10, 465, 535, 102);
        this.getContentPane().add(panel);
        JButton btnApply = new JButton("Apply");
        btnApply.setBounds(406, 11, 89, 23);
        panel.add(btnApply);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setBounds(406, 45, 89, 23);
        panel.add(btnCancel);
        JButton btnRefresh = new JButton("Refresh");
        btnRefresh.setBounds(293, 11, 89, 23);
        btnRefresh.setEnabled(enable);
        panel.add(btnRefresh);
        JButton btnSaveAsDefault = new JButton("Save As Default");
        btnSaveAsDefault.setBounds(0, 11, 136, 23);
        btnSaveAsDefault.setEnabled(enable);
        panel.add(btnSaveAsDefault);
        JButton btnSave = new JButton("Save");
        btnSave.setBounds(146, 11, 89, 23);
        btnSave.setEnabled(enable);
        panel.add(btnSave);
        JButton btnReset = new JButton("Reset to Default");
        btnReset.setBounds(0, 45, 136, 23);
        btnReset.setEnabled(enable);
        panel.add(btnReset);
        JButton btnLoad = new JButton("Load");
        btnLoad.setEnabled(enable);
        btnLoad.setBounds(146, 45, 89, 23);
        panel.add(btnLoad);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(10, 11, 525, 459);
        this.getContentPane().add(tabbedPane);
        JPanel pnlGeneral = new JPanel();
        tabbedPane.addTab("General", null, pnlGeneral, null);
        pnlGeneral.setLayout(null);
        JLabel lblIsoLanguage = new JLabel("ISO 629-1 Language Name:");
        lblIsoLanguage.setBounds(10, 11, 182, 14);
        pnlGeneral.add(lblIsoLanguage);
        this.cbDefLanguage = new JComboBox();
        this.cbDefLanguage.setBounds(222, 8, 96, 20);
        pnlGeneral.add(this.cbDefLanguage);
        JLabel lblLanguagecountry = new JLabel("Language (Country)");
        lblLanguagecountry.setBounds(10, 40, 154, 14);
        pnlGeneral.add(lblLanguagecountry);
        JLabel lblLanguage = new JLabel("Language");
        lblLanguage.setBounds(10, 65, 154, 14);
        pnlGeneral.add(lblLanguage);
        JLabel lblCharacterVariation = new JLabel("Character variation");
        lblCharacterVariation.setBounds(10, 90, 154, 14);
        pnlGeneral.add(lblCharacterVariation);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(null, "Fonts", 4, 2, null, null));
        panel_1.setBounds(10, 136, 304, 95);
        pnlGeneral.add(panel_1);
        panel_1.setLayout(null);
        JButton btnDictionaries = new JButton("Dictionaries");
        btnDictionaries.setBounds(10, 56, 109, 23);
        btnDictionaries.setEnabled(enable);
        panel_1.add(btnDictionaries);
        JButton btnTexts = new JButton("Texts");
        btnTexts.setBounds(10, 24, 109, 23);
        btnTexts.setEnabled(enable);
        panel_1.add(btnTexts);
        JLabel lblTextFont = new JLabel("Text font");
        lblTextFont.setBounds(129, 28, 165, 19);
        panel_1.add(lblTextFont);
        JLabel lblDictionaryFont = new JLabel("Dictionary font");
        lblDictionaryFont.setBounds(129, 60, 165, 19);
        panel_1.add(lblDictionaryFont);
        JPanel pnlLexAnalysis = new JPanel();
        tabbedPane.addTab("Lexical Analysis", null, pnlLexAnalysis, null);
        pnlLexAnalysis.setLayout(null);
        JLabel lblLexicalResources = new JLabel("Lexical Resources for: <lang>");
        lblLexicalResources.setBounds(10, 11, 159, 14);
        pnlLexAnalysis.add(lblLexicalResources);
        JLabel lblPriorityLevel = new JLabel("Priority Level:");
        lblPriorityLevel.setBounds(190, 11, 89, 14);
        pnlLexAnalysis.add(lblPriorityLevel);
        this.btnHigh = new JButton("High");
        this.btnHigh.setFont(new Font("Tahoma", 1, 11));
        this.btnHigh.setForeground(Color.RED);
        this.btnHigh.setBounds(281, 7, 59, 23);
        pnlLexAnalysis.add(this.btnHigh);
        JButton btnRegular = new JButton("Regular");
        btnRegular.setForeground(Color.RED);
        btnRegular.setFont(new Font("Tahoma", 1, 11));
        btnRegular.setBounds(350, 7, 81, 23);
        pnlLexAnalysis.add(btnRegular);
        this.btnLow = new JButton("Low");
        this.btnLow.setFont(new Font("Tahoma", 1, 11));
        this.btnLow.setForeground(Color.RED);
        this.btnLow.setBounds(441, 7, 59, 23);
        pnlLexAnalysis.add(this.btnLow);
        Object[] columnNames = new String[]{"Dictionary", "Priority"};
        DefaultTableModel dicModel = new DefaultTableModel((Object[][])null, columnNames);
        this.tableDictionary = new JTable(dicModel);
        this.tableDictionary.setName("DictionaryTable");
        this.tableDictionary.setRowHeight(22);
        JScrollPane scrollDictionary = new JScrollPane(this.tableDictionary);
        scrollDictionary.setBounds(10, 36, 226, 171);
        pnlLexAnalysis.add(scrollDictionary);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.tableDictionary.getColumnCount(); ++i) {
            this.tableDictionary.setDefaultRenderer(this.tableDictionary.getColumnClass(i), renderer);
        }
        Object[] columnNames1 = new String[]{"Morphology", "Priority"};
        DefaultTableModel morModel = new DefaultTableModel((Object[][])null, columnNames1);
        this.tableMorphology = new JTable(morModel);
        this.tableMorphology.setName("MorphologyTable");
        this.tableMorphology.setRowHeight(22);
        JScrollPane scrollMorphology = new JScrollPane(this.tableMorphology);
        scrollMorphology.setBounds(246, 36, 234, 171);
        pnlLexAnalysis.add(scrollMorphology);
        this.tableDictionary.setAutoCreateRowSorter(false);
        this.tableMorphology.setAutoCreateRowSorter(false);
        this.tableDictionary.getColumnModel().getColumn(1).setMaxWidth(50);
        this.tableMorphology.getColumnModel().getColumn(1).setMaxWidth(50);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tableDictionary.getModel());
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        this.tableDictionary.setRowSorter(sorter);
        TableRowSorter<TableModel> sorter2 = new TableRowSorter<TableModel>(this.tableMorphology.getModel());
        sorter2.setSortable(0, false);
        sorter2.setSortable(1, false);
        this.tableMorphology.setRowSorter(sorter2);
        PreferenceTableSorter dicSorter = new PreferenceTableSorter(this.tableDictionary);
        PreferenceTableSorter morphSorter = new PreferenceTableSorter(this.tableMorphology);
        this.tableDictionary.getTableHeader().addMouseListener(dicSorter);
        this.tableMorphology.getTableHeader().addMouseListener(morphSorter);
        this.tableDictionary.setSelectionMode(0);
        for (int i = 0; i < this.tableMorphology.getColumnCount(); ++i) {
        }
        this.tableDictionary.setFillsViewportHeight(true);
        this.tableMorphology.setFillsViewportHeight(true);
        JButton btnUncheckAllDic = new JButton("Uncheck All");
        btnUncheckAllDic.setBounds(10, 213, 109, 23);
        pnlLexAnalysis.add(btnUncheckAllDic);
        JButton btnCheckAllDic = new JButton("Check All");
        btnCheckAllDic.setBounds(147, 213, 89, 23);
        pnlLexAnalysis.add(btnCheckAllDic);
        JButton btnUncheckAllMorph = new JButton("Uncheck All");
        btnUncheckAllMorph.setBounds(246, 213, 109, 23);
        pnlLexAnalysis.add(btnUncheckAllMorph);
        JButton btnCheckAllMorph = new JButton("CheckAll");
        btnCheckAllMorph.setBounds(391, 213, 89, 23);
        pnlLexAnalysis.add(btnCheckAllMorph);
        this.lblLexDoc = new JLabel("Selected file");
        this.lblLexDoc.setBounds(10, 240, 470, 20);
        pnlLexAnalysis.add(this.lblLexDoc);
        this.txtFileInfoLex = new JTextArea();
        this.txtFileInfoLex.setBounds(10, 263, 470, 96);
        this.txtFileInfoLex.setBorder(new BevelBorder(1, null, null, null, null));
        pnlLexAnalysis.add(this.txtFileInfoLex);
        this.btnEditLex = new JButton("Edit");
        this.btnEditLex.setBounds(411, 385, 89, 23);
        pnlLexAnalysis.add(this.btnEditLex);
        this.btnImportFileLex = new JButton("Import File");
        this.btnImportFileLex.setBounds(302, 385, 99, 23);
        pnlLexAnalysis.add(this.btnImportFileLex);
        this.btnDeleteFileLex = new JButton("Delete File");
        this.btnDeleteFileLex.setBounds(193, 385, 99, 23);
        pnlLexAnalysis.add(this.btnDeleteFileLex);
        JPanel pnlSynAnalysis = new JPanel();
        tabbedPane.addTab("Syntactic Analysis", null, pnlSynAnalysis, null);
        pnlSynAnalysis.setLayout(null);
        JLabel lblAvailableSyntacticResource = new JLabel("Available Syntactic Resources for: <lang>");
        lblAvailableSyntacticResource.setBounds(10, 11, 236, 14);
        pnlSynAnalysis.add(lblAvailableSyntacticResource);
        JLabel lblApplyFollowingResources = new JLabel("Apply Following Resources:");
        lblApplyFollowingResources.setBounds(245, 11, 197, 14);
        pnlSynAnalysis.add(lblApplyFollowingResources);
        this.txtFileInfoSyn = new JTextArea();
        this.txtFileInfoSyn.setBounds(10, 263, 470, 96);
        this.txtFileInfoSyn.setBorder(new BevelBorder(1, null, null, null, null));
        pnlSynAnalysis.add(this.txtFileInfoSyn);
        this.btnDeleteFileSyn = new JButton("Delete File");
        this.btnDeleteFileSyn.setBounds(193, 385, 99, 23);
        pnlSynAnalysis.add(this.btnDeleteFileSyn);
        this.btnImportFileSyn = new JButton("Import File");
        this.btnImportFileSyn.setBounds(302, 385, 99, 23);
        pnlSynAnalysis.add(this.btnImportFileSyn);
        JButton btnEditSyn = new JButton("Edit");
        btnEditSyn.setBounds(411, 385, 89, 23);
        pnlSynAnalysis.add(btnEditSyn);
        DefaultListModel listModel = new DefaultListModel();
        this.listSynResources = new JList(listModel);
        JScrollPane scrollSynResources = new JScrollPane(this.listSynResources);
        scrollSynResources.setBounds(10, 37, 185, 181);
        pnlSynAnalysis.add(scrollSynResources);
        Object[] columnNamesResources = new String[]{"Order", "Grammar"};
        DefaultTableModel resModel = new DefaultTableModel((Object[][])null, columnNamesResources);
        this.tableResources = new JTable(resModel);
        this.tableResources.setName("ResourcesTable");
        this.tableResources.setAutoCreateRowSorter(false);
        this.tableResources.setFillsViewportHeight(true);
        this.tableResources.setSelectionMode(0);
        JScrollPane scrollResources = new JScrollPane(this.tableResources);
        scrollResources.setBounds(243, 37, 194, 181);
        pnlSynAnalysis.add(scrollResources);
        JButton buttonTransfer = new JButton(">");
        buttonTransfer.setFont(new Font("Tahoma", 1, 11));
        buttonTransfer.setForeground(Color.RED);
        buttonTransfer.setBounds(199, 37, 41, 34);
        pnlSynAnalysis.add(buttonTransfer);
        JButton btnH = new JButton("H");
        btnH.setForeground(Color.RED);
        btnH.setFont(new Font("Tahoma", 1, 11));
        btnH.setBounds(442, 36, 40, 34);
        pnlSynAnalysis.add(btnH);
        JButton btnL = new JButton("L");
        btnL.setFont(new Font("Tahoma", 1, 11));
        btnL.setForeground(Color.RED);
        btnL.setBounds(442, 81, 40, 34);
        pnlSynAnalysis.add(btnL);
        JButton btnX = new JButton("X");
        btnX.setForeground(Color.RED);
        btnX.setFont(new Font("Tahoma", 1, 11));
        btnX.setBounds(442, 184, 40, 34);
        pnlSynAnalysis.add(btnX);
        this.lblSynDoc = new JLabel("File location");
        this.lblSynDoc.setBounds(10, 229, 389, 14);
        pnlSynAnalysis.add(this.lblSynDoc);
        CopyToPreferences copyToPreferences = new CopyToPreferences(this);
        this.updateDialogListener = new UpdateDialogListener(this, this.cbDefLanguage, this.TFont, this.DFont, lblTextFont, lblDictionaryFont);
        btnTexts.addActionListener(new TextsActionListener(this, lblTextFont));
        btnDictionaries.addActionListener(new DictionariesActionListener(this, lblDictionaryFont));
        btnReset.addActionListener(new DefaultActionListener(this.updateDialogListener));
        btnLoad.addActionListener(new LoadActionListener(this, this.updateDialogListener));
        btnRefresh.addActionListener(new RefreshActionListener(this, this.updateDialogListener));
        btnCancel.addActionListener(new CancelActionListener(this));
        this.btnImportFileLex.addActionListener(new ImportLexActionListener(this, this.updateDialogListener));
        this.btnImportFileSyn.addActionListener(new ImportLexActionListener(this, this.updateDialogListener));
        UpdateTablesListener tableListener = new UpdateTablesListener(this.tableDictionary, this.tableMorphology, this.listSynResources, this.tableResources, this);
        this.selectDefLanguageListener = new SelectDefLanguageActionListener(this.cbDefLanguage, lblLexicalResources, lblAvailableSyntacticResource, lblLanguagecountry, lblLanguage, lblCharacterVariation, tableListener);
        this.cbDefLanguage.addActionListener(this.selectDefLanguageListener);
        btnCheckAllDic.addActionListener(new CheckAllActionListener(this, 0, true));
        btnUncheckAllDic.addActionListener(new CheckAllActionListener(this, 0, false));
        btnCheckAllMorph.addActionListener(new CheckAllActionListener(this, 1, true));
        btnUncheckAllMorph.addActionListener(new CheckAllActionListener(this, 1, false));
        this.btnHigh.addActionListener(new PriorityLexActionListener(1, this.lblLexDoc, this));
        this.btnLow.addActionListener(new PriorityLexActionListener(-1, this.lblLexDoc, this));
        btnRegular.addActionListener(new PriorityLexActionListener(0, this.lblLexDoc, this));
        buttonTransfer.addActionListener(new AddGrmActionListener(this));
        btnH.addActionListener(new PrioritySynActionListener(-1, this));
        btnL.addActionListener(new PrioritySynActionListener(1, this));
        btnX.addActionListener(new PrioritySynActionListener(0, this));
        this.btnDeleteFileLex.addActionListener(new DeleteLexActionListener(this, this.lblLexDoc, this.lblSynDoc, this.btnDeleteFileLex, this.btnDeleteFileSyn));
        this.btnDeleteFileSyn.addActionListener(new DeleteLexActionListener(this, this.lblLexDoc, this.lblSynDoc, this.btnDeleteFileLex, this.btnDeleteFileSyn));
        this.btnEditLex.addActionListener(new EditLexActionListener(this, this.lblLexDoc, this.lblSynDoc, true));
        btnEditSyn.addActionListener(new EditLexActionListener(this, this.lblLexDoc, this.lblSynDoc, false));
        this.updateDialogListener.updateFromFormMainPreferences();
        btnApply.addActionListener(new ApplyActionListener(this, copyToPreferences));
        btnSave.addActionListener(new SaveActionListener(this, copyToPreferences));
        btnSaveAsDefault.addActionListener(new SaveAsDefaultActionListener(copyToPreferences));
        this.tableResources.getTableHeader().addMouseListener(new PreferenceResourcesTableSorter(this.tableResources));
        copyToPreferences.CopyToPref();
        if (this.oldLan != Launcher.preferences.deflanguage) {
            Launcher.setOpenDirectories();
        }
    }

    public JComboBox getCbDefLanguage() {
        return this.cbDefLanguage;
    }

    public Font getDFont() {
        return this.DFont;
    }

    public void setDFont(Font dFont) {
        this.DFont = dFont;
    }

    public Font getTFont() {
        return this.TFont;
    }

    public void setTFont(Font tFont) {
        this.TFont = tFont;
    }

    public JTable getTableMorphology() {
        return this.tableMorphology;
    }

    public JTable getTableDictionary() {
        return this.tableDictionary;
    }

    public JTable getTableResources() {
        return this.tableResources;
    }

    public JList getListSynResources() {
        return this.listSynResources;
    }

    public JLabel getLblLexDoc() {
        return this.lblLexDoc;
    }

    public JLabel getLblSynDoc() {
        return this.lblSynDoc;
    }

    public JTextArea getTxtFileInfoLex() {
        return this.txtFileInfoLex;
    }

    public JButton getBtnImportFileLex() {
        return this.btnImportFileLex;
    }

    public JTextArea getTxtFileInfoSyn() {
        return this.txtFileInfoSyn;
    }

    public SelectDefLanguageActionListener getSelectDefLanguageListener() {
        return this.selectDefLanguageListener;
    }

    public String getOldLan() {
        return this.oldLan;
    }
}

